//
//  SubForm02ViewController.m
//  iOS SDK Sample
//
//  Created by NEI アプリGr on 2013/06/27.
//  Copyright (c) 2013年 Nippon Primex Inc. All rights reserved.
//

#import "SubForm02ViewController.h"

@interface SubForm02ViewController ()

@end

@implementation SubForm02ViewController

@synthesize objLib = mObjLib;
@synthesize strPrtName = mStrPrtName;
@synthesize sclView = mSclView;

-(void) btnViewSetting : (UIButton *) btnObj
{
    NSString* osversion = [UIDevice currentDevice].systemVersion;
    NSArray* a = [osversion componentsSeparatedByString:@"."];
    
    if([(NSString*)[a objectAtIndex:0] intValue] >= 7)
    {
        btnObj.layer.borderColor = [UIColor blueColor].CGColor;
        btnObj.layer.borderWidth = 1.0f;
        btnObj.layer.cornerRadius = 7.5f;
        
        btnObj.backgroundColor = [UIColor colorWithRed:0.95 green:1.0 blue:1.0 alpha:1.0];
        [btnObj setTintColor:[UIColor blackColor]];
    }
}

-(void) setReturnCode :(int) nmsResult
{
    lblReturnCode.text = [NSString stringWithFormat:@"Return Code: %d", nmsResult];
    
    if(nmsResult != 0)
    {
        lblReturnCode.textColor = [UIColor redColor];
    }
    else
    {
        lblReturnCode.textColor = [UIColor blackColor];
    }
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

-(void) appClose
{
    [mObjLib NClosePrinters];
}

-(void) viewDidLayoutSubviews
{
    int nmsWidth    = 0;
    int nmsHeight    = btnBack.frame.origin.y + btnBack.frame.size.height + 150;
    
    [mSclView setContentSize: CGSizeMake(nmsWidth, nmsHeight)];
    [mSclView flashScrollIndicators];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self btnViewSetting:btnNPrint];
    [self btnViewSetting:btnNDPrint];
    [self btnViewSetting:btnNImagePrintF];
    [self btnViewSetting:btnImageTypeSelect];
    [self btnViewSetting:btnNStartDoc];
    [self btnViewSetting:btnNEndDoc];
    [self btnViewSetting:btnNCancelDoc];
    [self btnViewSetting:btnBack];
    
	// Do any additional setup after loading the view.
    txtPrintData.delegate = self;
    txtImageFilePath.delegate = self;
    
    // App close setting(Enter backgroud)
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(appClose)
                                                 name:UIApplicationDidEnterBackgroundNotification object:nil];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)pushBtnNPrint:(UIButton *)sender
{
    int nmsRet = 0;
    int io_jobid = 0;

    int length = (int)[[txtPrintData text] length];

    // comment:NPI NPrint
    nmsRet = [mObjLib NPrint: mStrPrtName : [txtPrintData text] : length: &io_jobid];
        
    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnNDPrint:(UIButton *)sender
{
    int nmsRet = 0;
    int io_jobid = 0;
    unsigned char tmpBuf[3] = {0x1B,0x6D};

    NSData* rawSendBuf = [NSData dataWithBytes:tmpBuf length:2];
    
    // comment:NPI NDPrint
    nmsRet = [mObjLib NDPrint: mStrPrtName : rawSendBuf :sizeof(tmpBuf) : &io_jobid];
    
    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnNImagePrintF:(UIButton *)sender
{
    int nmsRet = 0;
    int io_jobid = 0;
    int i_putType = [self getImageType];
    
    NSArray* items = [[txtImageFilePath text] componentsSeparatedByString:@"."];
    
    NSString* filePath = [[NSBundle mainBundle] pathForResource:[items objectAtIndex:0] ofType:[items objectAtIndex:1]];
    
    if(filePath == nil)
    {
        NSArray* paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);

        filePath = [NSString stringWithFormat:@"%@/%@",[paths objectAtIndex:0],[txtImageFilePath text]];
    }
    
    // comment:NPI NImagePrintF
    nmsRet = [mObjLib NImagePrintF: mStrPrtName : filePath :i_putType : &io_jobid];

    [self setReturnCode:nmsRet];
}



- (IBAction)pushBtnNStartDoc:(UIButton *)sender
{
    int nmsRet = 0;
    int io_jobid = 0;
    
    // comment:NPI NStartDoc
    nmsRet = [mObjLib NStartDoc: mStrPrtName : &io_jobid];
    
    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnNEndDoc:(UIButton *)sender
{
    int nmsRet = 0;
    
    // comment:NPI NEndDoc
    nmsRet = [mObjLib NEndDoc: mStrPrtName];
    
    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnNCancelDoc:(UIButton *)sender
{
    int nmsRet = 0;
    
    // comment:NPI NCancelDoc
    nmsRet = [mObjLib NCancelDoc: mStrPrtName];
    
    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnImageTypeSelect:(UIButton *)sender
{
    NSString* lblText = [lblImageType text];
    
    if([lblText isEqualToString:@"Raster line"])
    {
        lblImageType.text = @"Raster block";
    }
    else if([lblText isEqualToString:@"Raster block"])
    {
        lblImageType.text = @"Raster gradation";
        lblImageType.adjustsFontSizeToFitWidth = YES;
    }
    else if([lblText isEqualToString:@"Raster gradation"])
    {
        lblImageType.text = @"Bit image";
    }
    else
    {
        lblImageType.text = @"Raster line";
    }
}

-(int) getImageType
{
    int nmsReturnCode = 0;
    NSString* lblText = [lblImageType text];
    
    if([lblText isEqualToString:@"Raster line"])
    {
        nmsReturnCode = 0x00;
    }
    else if([lblText isEqualToString:@"Raster block"])
    {
        nmsReturnCode = 0x01;
    }
    else if([lblText isEqualToString:@"Raster gradation"])
    {
        nmsReturnCode = 0x02;
    }
    else
    {
        nmsReturnCode = 0x10;
    }
    
    return nmsReturnCode;
}

- (IBAction)pushBtnBack:(UIButton *)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

-(BOOL)textFieldShouldReturn:(UITextField*) textField {
    [textField resignFirstResponder];
    return YES;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    // キーボード表示・非表示時のイベント登録
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasShown:)
                                                 name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasHidden:)
                                                 name:UIKeyboardDidHideNotification object:nil];
}

- (void)viewWillDisappear:(BOOL)animated {
    // キーボード表示・非表示時のイベント削除
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)keyboardWasShown:(NSNotification *)notification {
    NSDictionary *info = [notification userInfo];
    CGSize kbSize = [[info objectForKey:UIKeyboardFrameBeginUserInfoKey] CGRectValue].size;
    
    UIEdgeInsets contentInsets = UIEdgeInsetsMake(0.0, 0.0, kbSize.height, 0.0);
    
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
    
    CGRect aRect = self.view.frame;
    aRect.size.height -= kbSize.height;
    if (_activeField != nil) {
        CGPoint scrollPoint = CGPointMake(0.0, _activeField.frame.origin.y - 30);
        [self.sclView setContentOffset:scrollPoint animated:YES];
    }
}

- (void)keyboardWasHidden:(NSNotification *)notification {
    UIEdgeInsets contentInsets = UIEdgeInsetsZero;
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
}

- (void)textFieldDidBeginEditing:(UITextField *)textField {
    _activeField = textField;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    _activeField = nil;
}


@end
